//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// XTPerfoPage.
//=============================================================================
class XTPerfoPage expands UMenuPageWindow;

var UWindowSmallCloseButton CloseButton;
var UWindowCheckbox projcheck,coronacheck,lensflarecheck,beamcheck,aura,overlayer,envmap;
var UWindowCheckbox emitterglow,emitterlos,emitterfov,emitternear,emitterdistance;
var UWindowHSliderControl particledetail;
var string pcount;


function Created()
{
	CloseButton = UWindowSmallCloseButton(CreateControl(class'UWindowSmallCloseButton', WinWidth-64, WinHeight-32, 48, 16));
	CloseButton.SetHelpText("Close the menu and save your current settings!");

	//check/uncheck projectors:
	projcheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 20, 190, 1));
	if(class'xtmutator'.default.bprojectors) projcheck.bChecked = true;	
	else projcheck.bChecked = false;
	projcheck.SetText("Projectors");
	projcheck.SetHelpText("Check this option to toggle using Projectors");
	projcheck.SetFont(F_Normal);
	projcheck.Align = TA_Left;

	//check/uncheck dynamic coronas:
	coronacheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 40, 190, 1));
	if(class'xtmutator'.default.bdynamiccoronas) coronacheck.bChecked = true;	
	else coronacheck.bChecked = false;
	coronacheck.SetText("Dynamic Coronas");
	coronacheck.SetHelpText("Check this if you want dynamic coronas to be drawn");
	coronacheck.SetFont(F_Normal);
	coronacheck.Align = TA_Left;

	//check/uncheck lensflares:
	lensflarecheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 60, 190, 1));
	if(class'xtmutator'.default.benablelensflares) lensflarecheck.bChecked = true;	
	else lensflarecheck.bChecked = false;
	lensflarecheck.SetText("Lensflares");
	lensflarecheck.SetHelpText("Check this if you want lensflares to be drawn");
	lensflarecheck.SetFont(F_Normal);
	lensflarecheck.Align = TA_Left;

	//check/uncheck spritebeams:
	beamcheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 80, 190, 1));
	if(class'xtmutator'.default.bspritebeams) beamcheck.bChecked = true;
	else beamcheck.bChecked = false;
	beamcheck.SetText("Sprite Beams");
	beamcheck.SetHelpText("Check this if you want spritebeams to be set");
	beamcheck.SetFont(F_Normal);
	beamcheck.Align = TA_Left;

	//overlayer:
	overlayer = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 100, 190, 1));
	if(class'xtmutator'.default.boverlayer) overlayer.bChecked = true;	
	else overlayer.bChecked = false;
	overlayer.SetText("Overlayer System");
	overlayer.SetHelpText("Enable or disable overlayer effects");
	overlayer.SetFont(F_Normal);
	overlayer.Align = TA_Left;

	//overlayer:
	aura = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 120, 190, 1));
	if(class'xtmutator'.default.baura) aura.bChecked = true;	
	else overlayer.bChecked = false;
	aura.SetText("Volumetric Auras");
	aura.SetHelpText("Enable or disable volumetric auras");
	aura.SetFont(F_Normal);
	aura.Align = TA_Left;

    //environment mapping:
	envmap = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 140, 190, 1));
	if(class'xtmutator'.default.benv)envmap.bChecked = true;	
	else envmap.bChecked = false;
	envmap.SetText("Environment Mapping");
	envmap.SetHelpText("Turn overlayed environment mapping for meshes on/off");
	envmap.SetFont(F_Normal);
	envmap.Align = TA_Left;

	//check/uncheck los culling:
	emitterlos = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 160, 190, 1));
	if(class'xtmutator'.default.bemitterlos) emitterlos.bChecked = true;
	else emitterlos.bChecked = false;
	emitterlos.SetText("LOS Check");
	emitterlos.SetHelpText("Turn Emitter LineOfSight Check on/off");
	emitterlos.SetFont(F_Normal);
	emitterlos.Align = TA_Left;

	//check/uncheck fov culling:
	emitterfov = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 180, 190, 1));
	if(class'xtmutator'.default.bemitterfov) emitterfov.bChecked = true; else emitterfov.bChecked = false;
	emitterfov.SetText("FOV Check");
	emitterfov.SetHelpText("Turn Emitter Field of View Check on/off");
	emitterfov.SetFont(F_Normal);
	emitterfov.Align = TA_Left;

	//check/uncheck distance culling:
	emitterdistance = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 200, 190, 1));
	if(class'xtmutator'.default.bemitterdist) emitterdistance.bChecked = true; else emitterdistance.bChecked = false;
	emitterdistance.SetText("Distance Culling");
	emitterdistance.SetHelpText("Turn Emitter Distance Culling on/off");
	emitterdistance.SetFont(F_Normal);
	emitterdistance.Align = TA_Left;

	//check/uncheck near dropdown:
	emitternear = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 220, 190, 1));
	if(class'xtmutator'.default.bemitternear) emitternear.bChecked = true; else emitternear.bChecked = false;
	emitternear.SetText("Near Dropdown");
	emitternear.SetHelpText("Check/Uncheck using detail dropdown while being near towards an emitter");
	emitternear.SetFont(F_Normal);
	emitternear.Align = TA_Left;

	//check/uncheck glow effect:
	emitterglow = UWindowCheckbox(CreateControl(class'UWindowCheckbox', WinLeft+32, 240, 190, 1));
	if(class'xtmutator'.default.bemitterglow) emitterglow.bChecked = true; else emitterglow.bChecked = false;
	emitterglow.SetText("Glow Effects");
	emitterglow.SetHelpText("Turn Emitter Glow Effect (as seen on flames for example) on/off");
	emitterglow.SetFont(F_Normal);
	emitterglow.Align = TA_Left;

	//particle detail:
	particledetail = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', winleft+32, 260, 190, 1));
	particledetail.bNoSlidingNotify = True;
	particledetail.SetRange(0,6,1);
	particledetail.SetValue(class'xtmutator'.default.particledetail, True);
	particledetail.SetFont(F_Normal);
	setparticledetailcount(particledetail.getvalue());
	particledetail.SetHelpText("Change the particel-detail of the emitters");
    Super.Created();
}

function Notify(UWindowDialogControl C, byte E)
{
	local int i;
	super.Notify(C, E);
	switch(E)
	{
		case DE_Change:
			switch(C)
			{
				case projcheck: SetProj(); break;
				case coronacheck: SetCorona(); break;
				case lensflarecheck: SetLensflares(); break;
				case beamcheck: SetBeams(); break;
			    case overlayer: setoverlayer(); break;
				case aura: setaura(); break;
			    case envmap: setenvmap(); break;
				case emitterlos: setemitterlos(); break;
			    case emitterfov: setemitterfov(); break;
			    case emitterdistance: setemitterdist(); break;
			    case emitternear: setemitternear(); break;
			    case emitterglow: setemitterglow(); break;
			    case particledetail: Setparticledetail(); break;
			}
	}
}
function SetProj()
{
	class'xtmutator'.default.bprojectors = projcheck.bChecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function SetCorona()
{
	class'xtmutator'.default.bdynamiccoronas = coronacheck.bChecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function SetLensflares()
{
	class'xtmutator'.default.benablelensflares = lensflarecheck.bChecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function SetBeams()
{
	class'xtmutator'.default.bspritebeams = beamcheck.bChecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setoverlayer()
{
	class'xtmutator'.default.boverlayer = overlayer.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setaura()
{
	class'xtmutator'.default.baura = aura.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setenvmap()
{
	class'xtmutator'.default.benv = envmap.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setemitterlos()
{
	class'xtmutator'.default.bemitterlos = emitterlos.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setemitterfov()
{
	class'xtmutator'.default.bemitterfov = emitterfov.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setemitterdist()
{
	class'xtmutator'.default.bemitterdist = emitterdistance.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setemitternear()
{
	class'xtmutator'.default.bemitternear = emitternear.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setemitterglow()
{
	class'xtmutator'.default.bemitterglow = emitterglow.bchecked;
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setparticledetail()
{
	class'xtmutator'.default.particledetail = particledetail.GetValue();
	setparticledetailcount(particledetail.getvalue());
	class'xtmutator'.SaveConfig();
	class'xtmutator'.static.StaticSaveConfig();
}
function Setparticledetailcount(int p)
{
    if (p==0) pcount="Off";
    else if (p==1) pcount="Lowest";
    else if (p==2) pcount="Low";
    else if (p==3) pcount="Medium";
    else if (p==4) pcount="High";
    else if (p==5) pcount="Higher";
    else pcount="Highest";
    particledetail.SetText("Emitters: "$pcount);
}
function Close(optional bool bByParent)
{
	Super.Close(bByParent);
}

defaultproperties
{
}
